﻿using System.Data;

public class StationConfiguration
{
    public string Access { get; private set; }
    public string Verify { get; private set; }
    public string Ssn { get; private set; }
    public string Duz { get; private set; }
    public string FullName { get; private set; }
    public string SiteName { get; private set; }

    public string GetStudyReportUrl { get; private set; }
    public string StudyQueryUrl { get; private set; }
    public string GetUserTokenUrl { get; private set; }
    public string GetServiceStatusUrl { get; }

    public StationConfiguration(IDataRecord dr)
    {
        Access = dr.GetString((int)StationConfigurationOrdinal.Access);
        Verify = dr.GetString((int)StationConfigurationOrdinal.Verify);
        Ssn = dr.GetString((int)StationConfigurationOrdinal.Ssn);
        Duz = dr.GetString((int)StationConfigurationOrdinal.Duz);
        FullName = dr.GetString((int)StationConfigurationOrdinal.FullName);
        SiteName = dr.GetString((int)StationConfigurationOrdinal.SiteName);
        GetStudyReportUrl = dr.GetString((int)StationConfigurationOrdinal.GetStudyReportUrl);
        StudyQueryUrl = dr.GetString((int)StationConfigurationOrdinal.StudyQueryUrl);
        GetUserTokenUrl = dr.GetString((int)StationConfigurationOrdinal.GetUserTokenUrl);
        GetServiceStatusUrl = dr.GetString((int)StationConfigurationOrdinal.GetServiceStatusUrl);
    }
}
